.model 1N4747 D(IS=1.65E-12 RS=10.9 TT=5.01E-8 CJO=6.25E-11 M=0.33 bv=19.87 IBV=0.0125 mfg=Motorola type=zener)
.model 1N4754 D(IS=2.67E-9 RS=36 TT=5.01E-8 CJO=3.93E-11 M=0.33 bv=38.78 IBV=0.0065 mfg=Motorola type=zener)
.model 1N4764 D(IS=2.67E-9 RS=289 TT=5.01E-8 CJO=2.45E-11 M=0.33 bv=99.32 IBV=0.0025 mfg=Motorola type=zener)
.model 1N4761 D(IS=2.67E-9 RS=171 TT=5.01E-8 CJO=3.3E-11 M=0.33 bv=75.32 IBV=0.0025 mfg=Motorola type=zener)

.SUBCKT 12AT7 1 2 3  ; P G C; NEW MODEL
+ PARAMS: MU=60 EX=1.35 KG1=460 KP=300 KVB=300 RGI=2000
+ CCG=2.3P  CGP=2.2P CCP=1.0P  ; ADD .7PF TO ADJACENT PINS; .5 TO OTHERS. 
E1 7 0 VALUE=
+{V(1,3)/KP*LOG(1+EXP(KP*(1/MU+V(2,3)/SQRT(KVB+V(1,3)*V(1,3)))))}
RE1 7 0 1G
G1 1 3 VALUE={(PWR(V(7),EX)+PWRS(V(7),EX))/KG1}
RCP 1 3 1G    ; TO AVOID FLOATING NODES IN MU-FOLLOWER
C1 2 3 {CCG}  ; CATHODE-GRID; WAS 1.6P
C2 2 1 {CGP}  ; GRID-PLATE; WAS 1.5P
C3 1 3 {CCP}  ; CATHODE-PLATE; WAS 0.5P
D3 5 3 DX     ; FOR GRID CURRENT
R1 2 5 {RGI}  ; FOR GRID CURRENT
.MODEL DX D(IS=1N RS=1 CJO=0 TT=1N)
.ENDS
*$

.SUBCKT 12AU7 1 2 3  ; P G C; NEW MODEL
+ PARAMS: MU=21.5 EX=1.3 KG1=1180 KP=84 KVB=300 RGI=2000
+ CCG=2.3P  CGP=2.2P CCP=1.0P  ; ADD .7PF TO ADJACENT PINS; .5 TO OTHERS. 
E1 7 0 VALUE=
+{V(1,3)/KP*LOG(1+EXP(KP*(1/MU+V(2,3)/SQRT(KVB+V(1,3)*V(1,3)))))}
RE1 7 0 1G
G1 1 3 VALUE={(PWR(V(7),EX)+PWRS(V(7),EX))/KG1}
RCP 1 3 1G    ; TO AVOID FLOATING NODES IN MU-FOLLOWER
C1 2 3 {CCG}  ; CATHODE-GRID; WAS 1.6P
C2 2 1 {CGP}  ; GRID-PLATE; WAS 1.5P
C3 1 3 {CCP}  ; CATHODE-PLATE; WAS 0.5P
D3 5 3 DX     ; FOR GRID CURRENT
R1 2 5 {RGI}  ; FOR GRID CURRENT
.MODEL DX D(IS=1N RS=1 CJO=0 TT=1N)
.ENDS
*$

.SUBCKT 12AX7 1 2 3  ; P G C;  NEW MODEL
+ PARAMS: MU=100 EX=1.7 KG1=1060 KP=600 KVB=300 RGI=2000 
+ CCG=2.3P  CGP=2.4P CCP=.9P  ; ADD .7PF TO ADJACENT PINS; .5 TO OTHERS. 
E1 7 0 VALUE=
+{V(1,3)/KP*LOG(1+EXP(KP*(1/MU+V(2,3)/SQRT(KVB+V(1,3)*V(1,3)))))}
RE1 7 0 1G
G1 1 3 VALUE={(PWR(V(7),EX)+PWRS(V(7),EX))/KG1}
RCP 1 3 1G    ; TO AVOID FLOATING NODES IN MU-FOLLOWER
C1 2 3 {CCG}  ; CATHODE-GRID
C2 2 1 {2.4P}  ; GRID=PLATE
C3 1 3 {CCP}  ; CATHODE-PLATE
D3 5 3 DX     ; FOR GRID CURRENT
R1 2 5 {RGI}  ; FOR GRID CURRENT
.MODEL DX D(IS=1N RS=1 CJO=0 TT=1N)
.ENDS
*$

.SUBCKT 6CA7 A S G K
*
* Calculate contribution to cathode current
*
Eat	at	0	VALUE={0.636*ATAN(V(A,K)/23)}
Egs	gs	0	VALUE={LIMIT(V(S,K)/9.3+V(G,K)*0.95,0,1E6)}
Egs2	gs2	0	VALUE={PWRS(V(gs),1.5)}
Ecath  	cc    	0 	VALUE={V(gs2)*V(at)}
*
* Calculate anode current
*
Ga     	A     	K     	VALUE={1.86E-3*V(cc)}
*
* Calculate screen current
*
Escrn	sc	0	VALUE={V(gs2)*(1.1-V(at))}
Gs     	S     	K	VALUE={1.518E-3*V(sc)*LIMIT(V(S,K),0,10)/10}
*
* Grid current (approximation - does not model low va/vs)
*
Gg	G	K	VALUE={PWR(LIMIT(V(G,K)+1,0,1E6),1.5)*50E-6}
*
* Capacitances
*
Cg1	G	K	15.4p
Cak	A	K	8.4p
Cg1a	G	A	1.1p
.ENDS
*$
.SUBCKT 6BQ5 A S G K
*
* Calculate contribution to cathode current
*
Eat	at	0	VALUE={0.636*ATAN(V(A,K)/15)}
Egs	gs	0	VALUE={LIMIT(V(S,K)/19+V(G,K)+V(A,K)/1400,0,1E6)}
Egs2	gs2	0	VALUE={PWRS(V(gs),1.5)}
Ecath  	cc    	0 	VALUE={V(gs2)*V(at)}
*
* Calculate anode current
*
Ga     	A     	K     	VALUE={3.2E-3*V(cc)}
*
* Calculate screen current
*
Escrn	sc	0	VALUE={V(gs2)*(1.1-V(at))}
Gs     	S     	K	VALUE={2.0E-3*V(sc)*LIMIT(V(S,K),0,10)/10}
*
* Grid current (approximation - does not model low va/vs)
*
Gg	G	K	VALUE={PWR(LIMIT(V(G,K)+1,0,1E6),1.5)*50E-6}
*
* Capacitances
*
Cg1	G	K	10.8p
Cak	A	K	6.5p
Cg1a	G	A	0.5p
.ENDS 
*$

.MODEL DN2540   NMOS (LEVEL=3   RS=1.05            NSUB=5.0E14
+DELTA=0.1      KAPPA=0.20      TPG=1              CGDO=3.1716E-10
+RD=11          VTO=-1.50       VMAX=1.0E7         ETA=0.0223089
+NFS=6.6E10     TOX=725E-10     LD=1.698E-9        UO=862.425
+XJ=6.4666E-7   THETA=1.0E-5    CGSO=2.50E-9       L=4.0E-6
+W=59E-3)
.ENDS
*

.SUBCKT 6DJ8 1 2 3  ; P G C; NEW MODEL
+ PARAMS: MU=28 EX=1.3 KG1=330 KP=320 KVB=300 RGI=2000
+ CCG=2.3P  CGP=2.1P CCP=.7P  ; ADD .7PF TO ADJACENT PINS; .5 TO OTHERS. 
E1 7 0 VALUE=
+{V(1,3)/KP*LOG(1+EXP(KP*(1/MU+V(2,3)/SQRT(KVB+V(1,3)*V(1,3)))))}
RE1 7 0 1G
G1 1 3 VALUE={(PWR(V(7),EX)+PWRS(V(7),EX))/KG1}
RCP 1 3 1G    ; TO AVOID FLOATING NODES IN MU-FOLLOWER
C1 2 3 {CCG}  ; CATHODE-GRID; WAS 1.6P
C2 2 1 {CGP}  ; GRID-PLATE; WAS 1.5P
C3 1 3 {CCP}  ; CATHODE-PLATE; WAS 0.5P
D3 5 3 DX     ; FOR GRID CURRENT
R1 2 5 {RGI}  ; FOR GRID CURRENT
.MODEL DX D(IS=1N RS=1 CJO=0 TT=1N)
.ENDS
*$

.SUBCKT ECL82 A S G K
*
* Calculate contribution to cathode current
*
Eat	at	0	VALUE={0.636*ATAN(V(A,K)/15)}
Egs	gs	0	VALUE={LIMIT{V(S,K)/7+V(G,K)*1.3+V(A,K)/700,0,1E6}}
Egs2	gs2	0	VALUE={PWRS(V(gs),1.24)}
Ecath  	cc    	0 	VALUE={V(gs2)*V(at)}
*
* Calculate anode current
*
Ga     	A     	K     	VALUE={3.45E-3*V(cc)}
*
* Calculate screen current
*
Escrn	sc	0	VALUE={V(gs2)*(1.1-V(at))}
Gs     	S     	K	VALUE={3.7E-3*V(sc)*LIMIT{V(S,K),0,10}/10}
*
* Capacitances
*
Cg1	G	K	9.6p
Cak	A	K	9.3p
Cg1a	G	A	0.35p
.ENDS
*$ 

.SUBCKT EF86 A S G K

*
* Calculate reduction in mu when Vg < -3V
*
Emu	mu	0	VALUE={LIMIT{V(G,K),-3,999}+LIMIT{V(G,K)+3,-999,0}*0.714}
*
* Calculate contribution to cathode current
*
Eat	at	0	VALUE={0.636*ATAN(V(A,K)/15)}
Egs	gs	0	VALUE={LIMIT{V(S,K)/27.5+V(mu)*1.32+1,0,1E6}}
Egs2	gs2	0	VALUE={PWRS(V(gs),1.5)}
Ecath  	cc    	0 	VALUE={V(gs2)*V(at)}
*
* Calculate anode current
*
Ga     	A     	K     	VALUE={5.83E-4*V(cc)}
*
* Calculate screen current
*
Escrn	sc	0	VALUE={V(gs2)*(1.1-V(at))}
Gs     	S     	K	VALUE={0.5E-3*V(sc)}
*
* Capacitances
*
Cg1	G	K	3.8p
Cak	A	K	5.3p
Cg1a	G	A	0.05p

.ENDS 
*$

***************** p g c ***************************************************
.subckt RCA12ax7  1 2 3
*************************  
eGIogVpc 20 0 value={log(v(1,3))}
rGlogVpc 20 0 1 
eG0 10 0 poly(1) <2,3>   -3.7694e+00   1.9947e+00   5.9432e-02    
eG1 11 0 poly(1) <2,3>   -3.2024e-02  -4.1443e-02  -4.8236e-03 
eG2 12 0 poly(1) <2,3>    1.9127e-02  -1.2189e-02  -1.5526e-03 
eG3 13 0 poly(1) <2,3>   -1.1354e-02   4.9339e-03   6.1016e-04  
rG0 10 0 1
rG1 11 0 1
rG2 12 0 1
rG3 13 0 1
gG   2 3 value={(exp(v(10)+v(20)*(v(11)+v(20)*(v(12)+v(20)*v(13)))))/170}
*
eP0 110 0 poly(1) <2,3>    -9.9158e+0  1.9145e+0 -2.8135e+0  1.8661e+0     
+						 1.5643e+0  4.7240e-1  6.4276e-2  3.3101e-3 
eP1 111 0 poly(1) <2,3>     9.5428e-1  3.2558e-2 -8.3349e-1 -4.8578e-2  
+						 2.6213e-1  1.0492e-1  1.8921e-2  1.3632e-3 
eP2 112 0 poly(1) <2,3>     9.5766e-2  2.5192e-2  2.2391e-1 -1.7040e-1 
+						-2.4952e-1 -1.0960e-1 -2.0981e-2 -1.4882e-3
eP3 113 0 poly(1) <2,3>    -6.6107e-2 -3.9657e-2  7.5560e-2  3.1025e-2  
+						 2.4265e-2  1.7002e-2  4.2512e-3  3.4761e-4
eP4 114 0 poly(1) <2,3>     8.4148e-3  4.7989e-3 -1.3258e-2 -1.9288e-3  
+						 5.2888e-4 -5.6853e-4 -2.4727e-4 -2.4359e-5
rP0 110 0 1
rP1 111 0 1
rP2 112 0 1
rP3 113 0 1
rP4 114 0 1
gP    1 3 value={(exp(v(110)+v(20)*(v(111)+v(20)*(v(112)+v(20)*(v(113)+v(20)*v(114))))))}
Cgc 2 3 1.8p
Cgp 2 1 1.7p
Cpc 1 3 1.9p
.ends
*$

.SUBCKT EL34 A S G K
*
* Calculate contribution to cathode current
*
Eat	at	0	VALUE={0.636*ATAN(V(A,K)/23)}
Egs	gs	0	VALUE={LIMIT(V(S,K)/9.3+V(G,K)*0.95,0,1E6)}
Egs2	gs2	0	VALUE={PWRS(V(gs),1.5)}
Ecath  	cc    	0 	VALUE={V(gs2)*V(at)}
*
* Calculate anode current
*
Ga     	A     	K     	VALUE={1.86E-3*V(cc)}
*
* Calculate screen current
*
Escrn	sc	0	VALUE={V(gs2)*(1.1-V(at))}
Gs     	S     	K	VALUE={1.518E-3*V(sc)*LIMIT(V(S,K),0,10)/10}
*
* Grid current (approximation - does not model low va/vs)
*
Gg	G	K	VALUE={PWR(LIMIT(V(G,K)+1,0,1E6),1.5)*50E-6}
*
* Capacitances
*
Cg1	G	K	15.4p
Cak	A	K	8.4p
Cg1a	G	A	1.1p

.ENDS
*$

.SUBCKT ECC85 A G K
* Generic triode model: 6AQ8
* Copyright 2003--2006 by Ayumi Nakabayashi, All rights reserved.
* Version 3.01, Generated on Wed Mar 22 17:19:36 2006
BGG GG 0 V=V(G,K)+0.46274
BEP EP 0 V=URAMP(V(A,K))+1e-10
BEG EG 0 V=URAMP(V(G,K))+1e-10
BM1 M1 0 V=(0.016397559*(URAMP(V(EP)-1e-10)+1e-10))^-1.8244468
BM2 M2 0 V=(0.45120289*(URAMP(V(GG)+V(EP)/33.468219)+1e-10))^3.3244468
BP P 0 V=0.0053412983*(URAMP(V(GG)+V(EP)/74.175541)+1e-10)^1.5
BIK IK 0 V=U(V(GG))*V(P)+(1-U(V(GG)))*0.0076348*V(M1)*V(M2)
BIG IG 0 V=0.0026706491*V(EG)^1.5*(V(EG)/(V(EP)+V(EG))*1.2+0.4)
BIAK A K I=URAMP(V(IK,IG)-URAMP(V(IK,IG)-(0.0027790257*V(EP)^1.5)))+1e-10*V(A,K)
BIGK G K I=V(IG)
* CAPS
CGA G A 1.5p
CGK G K 3.1p
CAK A K 1.2p
.ENDS
*$ 